/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import fuzs.puzzleslib.api.container.v1.NonInteractiveResultSlot;
import fuzs.puzzleslib.mixin.accessor.AbstractContainerMenuAccessor;
import fuzs.puzzleslib.mixin.accessor.SimpleContainerAccessor;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ContainerMenuHelper {
    private ContainerMenuHelper() {
    }

    public static void setSelectedSlotLocked(AbstractContainerMenu containerMenu) {
        for (int i = 0; i < containerMenu.f_38839_.size(); ++i) {
            Slot slot = (Slot)containerMenu.f_38839_.get(i);
            Container container = slot.f_40218_;
            if (!(container instanceof Inventory)) continue;
            Inventory inventory = (Inventory)container;
            if (inventory.f_35977_ != slot.m_150661_()) continue;
            NonInteractiveResultSlot newSlot = new NonInteractiveResultSlot(slot.f_40218_, slot.m_150661_(), slot.f_40220_, slot.f_40221_){

                @Override
                public boolean isFake() {
                    return false;
                }
            };
            newSlot.f_40219_ = slot.f_40219_;
            containerMenu.f_38839_.set(i, (Object)newSlot);
            break;
        }
    }

    public static void addInventorySlots(AbstractContainerMenu containerMenu, Inventory inventory, int offsetY) {
        ContainerMenuHelper.addInventorySlots(containerMenu, inventory, 8, offsetY);
    }

    public static void addInventorySlots(AbstractContainerMenu containerMenu, Inventory inventory, int offsetX, int offsetY) {
        int i;
        int slotSize = 18;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                ((AbstractContainerMenuAccessor)containerMenu).puzzleslib$callAddSlot(new Slot((Container)inventory, j + i * 9 + 9, offsetX + j * 18, offsetY));
            }
            offsetY += 18;
        }
        offsetY += 4;
        for (i = 0; i < 9; ++i) {
            ((AbstractContainerMenuAccessor)containerMenu).puzzleslib$callAddSlot(new Slot((Container)inventory, i, offsetX + i * 18, offsetY));
        }
    }

    public static SimpleContainer createListBackedContainer(NonNullList<ItemStack> items, @Nullable Container listener) {
        return ContainerMenuHelper.createListBackedContainer(items, listener != null ? $ -> listener.m_6596_() : null);
    }

    public static SimpleContainer createListBackedContainer(NonNullList<ItemStack> items, @Nullable ContainerListener listener) {
        SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[0]);
        ((SimpleContainerAccessor)simpleContainer).puzzleslib$setSize(items.size());
        ((SimpleContainerAccessor)simpleContainer).puzzleslib$setItems(items);
        if (listener != null) {
            simpleContainer.m_19164_(listener);
        }
        return simpleContainer;
    }

    public static void copyItemsIntoContainer(NonNullList<ItemStack> from, Container to) {
        for (int i = 0; i < from.size(); ++i) {
            if (i >= to.m_6643_()) continue;
            to.m_6836_(i, (ItemStack)from.get(i));
        }
    }

    public static void copyItemsIntoList(NonNullList<ItemStack> from, NonNullList<ItemStack> to) {
        for (int i = 0; i < from.size(); ++i) {
            if (i >= to.size()) continue;
            to.set(i, (Object)((ItemStack)from.get(i)));
        }
    }
}

